/* ************************************************************************ */
/*																			*/
/*  Neko Standard Library													*/
/*  Copyright (c)2005 Motion-Twin											*/
/*																			*/
/* This library is free software; you can redistribute it and/or			*/
/* modify it under the terms of the GNU Lesser General Public				*/
/* License as published by the Free Software Foundation; either				*/
/* version 2.1 of the License, or (at your option) any later version.		*/
/*																			*/
/* This library is distributed in the hope that it will be useful,			*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of			*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU		*/
/* Lesser General Public License or the LICENSE file for more details.		*/
/*																			*/
/* ************************************************************************ */
#include <neko.h>
#include <stdio.h>
#ifdef _WIN32
#	include <windows.h>
#else
#endif

extern vkind k_file;

static value create_process( value cmd, value args, value env ) {
#ifdef _WIN32
	buffer b;
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	char *env_str;
#endif
	FILE *in, *out, *err;
	val_check(cmd,string);
	val_check(args,string);
	if( !val_is_null(env) )
		val_check_kind(env,k_hash);
#ifdef _WIN32
	if( val_is_null(env) )
		env_str = NULL;
	else {
		vhash *h = (vhash*)val_data(env);
		int i;
		b = alloc_buffer(NULL);
		for(i=0;i<h->ncells;i++) {
			hcell *c = h->cells[i];
			while( c != NULL ) {
				val_check(c->key,string);
				val_check(c->val,string);
				val_buffer(b,c->key);
				buffer_append_char(b,'=');
				val_buffer(b,c->val);
				buffer_append_char(b,0);
				c = c->next;
			}
		}
		buffer_append_char(b,0);
		env_str = val_string(buffer_to_string(b));
	}
	memset(&si,0,sizeof(si));
	si.cb = sizeof(si);
	si.dwFlags |= STARTF_USESTDHANDLES;
	si.hStdInput = CreateFile;
	si.hStdOutput = out;
	si.hStdError = err;
	if( !CreateProcess(val_string(cmd),val_string(args),NULL,NULL,TRUE,0,env_str,NULL,&si,&pi) )		
		neko_error();
	WaitForSingleObject(pi.hProcess,INFINITE);
	CloseHandle(pi.hProcess);
	CloseHandle(pi.hThread);
	return alloc_int(pi.dwProcessId);
#endif
	neko_error();
	return val_null;
}

/*
let rec safe_dup fd =
  let new_fd = dup fd in
  if new_fd >= 3 then
    new_fd
  else begin
    let res = safe_dup fd in
    close new_fd;
    res
  end

let safe_close fd =
  try close fd with Unix_error(_,_,_) -> ()

let perform_redirections new_stdin new_stdout new_stderr =
  let newnewstdin = safe_dup new_stdin in
  let newnewstdout = safe_dup new_stdout in
  let newnewstderr = safe_dup new_stderr in
  safe_close new_stdin;
  safe_close new_stdout;
  safe_close new_stderr;
  dup2 newnewstdin stdin; close newnewstdin;
  dup2 newnewstdout stdout; close newnewstdout;
  dup2 newnewstderr stderr; close newnewstderr

let create_process cmd args new_stdin new_stdout new_stderr =
  match fork() with
    0 ->
      begin try
        perform_redirections new_stdin new_stdout new_stderr;
        execvp cmd args
      with _ ->
        exit 127
      end
  | id -> id
*/

DEFINE_PRIM(create_process,3);
